# 🚀 Guía de Implementación - Cotizador AFL Cargo
## Dominio: aflcargo.net

---

## 📋 Requisitos Previos

- VPS con Ubuntu 20.04/22.04 o similar
- Acceso root o sudo
- Dominio aflcargo.net apuntando al IP del VPS
- Puerto 80 y 443 abiertos
- MySQL/MariaDB instalado

---

## 📦 Contenido del Paquete

```
aflcargo_deploy_completo.zip
├── cotizar.html              # Página principal del cotizador
├── widget/
│   └── afl-quote-widget.js   # Widget embebible para otros sitios
├── api/
│   └── cotizacion-publica.php # Endpoint para guardar solicitudes
├── admin/
│   └── solicitudes.php       # Panel para gestionar solicitudes
├── database/
│   └── cotizaciones_publicas.sql # Estructura de la tabla
├── deploy.sh                 # Script de instalación automática
└── GUIA_IMPLEMENTACION_VPS.md
```

---

## 🚀 Instalación Rápida (5 minutos)

### 1. Subir y descomprimir

```bash
# Desde tu computadora local
scp aflcargo_deploy_completo.zip root@TU-IP:/root/

# Conectar al VPS
ssh root@TU-IP

# Descomprimir
cd /root
unzip aflcargo_deploy_completo.zip
```

### 2. Ejecutar el script de instalación

```bash
chmod +x deploy.sh
sudo bash deploy.sh
```

### 3. Configurar la base de datos

```bash
# Conectar a MySQL
mysql -u root -p

# Crear la tabla (ejecutar dentro de MySQL)
USE tu_base_de_datos;
SOURCE /root/database/cotizaciones_publicas.sql;
EXIT;
```

### 4. Configurar credenciales de BD

Editar los archivos PHP con tus credenciales:

```bash
# API
nano /var/www/aflcargo.net/api/cotizacion-publica.php
```

Buscar y modificar:
```php
$config = [
    'host' => 'localhost',
    'dbname' => 'tu_base_datos',     // ← Cambiar
    'user' => 'tu_usuario',          // ← Cambiar
    'pass' => 'tu_contraseña',       // ← Cambiar
    'charset' => 'utf8mb4'
];

$emailConfig = [
    'enabled' => true,
    'to' => 'ventas@aflcargo.net',   // ← Tu email de ventas
    ...
];
```

Hacer lo mismo para el admin:
```bash
nano /var/www/aflcargo.net/admin/solicitudes.php
```

### 5. Configurar WhatsApp

```bash
nano /var/www/aflcargo.net/cotizar/index.html
```

Buscar:
```javascript
whatsappNumber: '56912345678',  // ← Tu número real
```

### 6. Instalar HTTPS

```bash
apt install certbot python3-certbot-nginx -y
certbot --nginx -d aflcargo.net -d www.aflcargo.net
```

---

## 🌐 URLs Finales

| Recurso | URL |
|---------|-----|
| **Cotizador** | https://aflcargo.net/cotizar |
| **Panel Admin** | https://aflcargo.net/admin/solicitudes.php |
| **Widget JS** | https://aflcargo.net/widget/afl-quote-widget.js |
| **API** | https://aflcargo.net/api/cotizacion-publica.php |

---

## 🔐 Credenciales del Panel Admin

Por defecto:
- **Usuario:** admin
- **Contraseña:** aflcargo2024

⚠️ **CAMBIAR INMEDIATAMENTE** en:
```bash
nano /var/www/aflcargo.net/admin/solicitudes.php
```

Buscar:
```php
$adminUser = 'admin';
$adminPass = 'aflcargo2024';  // ← CAMBIAR
```

---

## 📊 Funcionalidades del Sistema

### Cotizador Web
- ✅ Formulario paso a paso
- ✅ Estimación de precio en tiempo real
- ✅ Bilingüe (español/inglés)
- ✅ Integración WhatsApp
- ✅ Responsive (móvil/desktop)

### Backend
- ✅ Guarda todas las solicitudes en MySQL
- ✅ Envía email de notificación
- ✅ API REST con CORS habilitado

### Panel Admin
- ✅ Lista de todas las solicitudes
- ✅ Filtros por estado
- ✅ Búsqueda
- ✅ Estadísticas
- ✅ Cambiar estado (nueva → contactada → cotizada → cerrada)
- ✅ Agregar notas internas
- ✅ Links directos a WhatsApp y Email

### Widget Embebible
- ✅ Un solo archivo JS
- ✅ Personalizable (color, posición, idioma)
- ✅ Funciona en cualquier sitio web

---

## 📧 Configurar Email (Opcional)

Para que las notificaciones por email funcionen, tu VPS necesita poder enviar correos. Opciones:

### Opción 1: Usar el servidor de correo local
```bash
apt install sendmail -y
```

### Opción 2: Usar SMTP externo (recomendado)
Instalar PHPMailer y configurar SMTP de Gmail/SendGrid/etc.

---

## 🔄 Actualizar Archivos

```bash
# Subir nuevos archivos
scp archivo.php root@TU-IP:/var/www/aflcargo.net/api/

# O editar directamente
ssh root@TU-IP
nano /var/www/aflcargo.net/cotizar/index.html
```

---

## 🛠️ Comandos Útiles

```bash
# Ver logs
tail -f /var/log/nginx/aflcargo.net.error.log

# Reiniciar servicios
systemctl restart nginx
systemctl restart php8.1-fpm

# Ver solicitudes en BD
mysql -u root -p -e "SELECT * FROM cotizaciones_publicas ORDER BY id DESC LIMIT 10;"

# Verificar PHP
php -v
```

---

## 🚨 Solución de Problemas

### "502 Bad Gateway"
```bash
systemctl restart php8.1-fpm
systemctl restart nginx
```

### API devuelve error de BD
- Verificar credenciales en cotizacion-publica.php
- Verificar que la tabla existe: `SHOW TABLES LIKE 'cotizaciones%';`

### No llegan emails
- Verificar que sendmail está instalado
- Revisar logs: `tail -f /var/log/mail.log`
- Considerar usar SMTP externo

### Widget no carga en otros sitios
- Verificar que CORS está habilitado
- El sitio debe usar HTTPS si tu widget usa HTTPS

---

*Guía actualizada - Diciembre 2024*
